package elaborator.utils;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import elaborator.Sender;

public class FileWriter implements Sender {

	private int[] temps;
	private int diameter;
	private Map<Double, String> elements = new TreeMap<Double, String>();
	private String filename;


	public void writeDatabase() {
		try {
			java.io.FileWriter writer = new java.io.FileWriter(new File(
					"database/" + filename + ".txt"));

			writer.write(temps[0] + " " + temps[1] + "\n");
			writer.write(diameter + "\n");

			Set<Double> keys = elements.keySet();

			for (Double key : keys) {

				String value = elements.get(key);
				writer.write(key + " " + value+"\n");
			}
			writer.close();

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void setTemps(int[] temps) {
		this.temps = temps;

	}

	@Override
	public void setDiameter(int diameter) {
		this.diameter = diameter;

	}

	@Override
	public void setComposition(Map<Double, String> elements) {
		this.elements = elements;
	}

	@Override
	public void setPlanetName(String planet) {
		this.filename = planet;

	}

}
